/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.sodium.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.caffeinemc.mods.sodium.client.render.immediate.CloudRenderer;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.pipeline.ShaderRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import net.irisshaders.iris.vertices.sodium.CloudVertex;
import net.minecraft.class_293;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CloudRenderer.class})
public abstract class MixinCloudRenderer {
    @Unique
    private static final int[] NORMALS = new int[]{NormI8.pack((float)0.0f, (float)-1.0f, (float)0.0f), NormI8.pack((float)0.0f, (float)1.0f, (float)0.0f), NormI8.pack((float)-1.0f, (float)0.0f, (float)0.0f), NormI8.pack((float)1.0f, (float)0.0f, (float)0.0f), NormI8.pack((float)0.0f, (float)0.0f, (float)-1.0f), NormI8.pack((float)0.0f, (float)0.0f, (float)1.0f)};
    @Unique
    private static int computedNormal;
    @Shadow
    private class_5944 shaderProgram;
    @Shadow(remap=false)
    @Nullable
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @Nullable CloudRenderer.CloudGeometry cachedGeometry;
    @Unique
    @Nullable
    private CloudRenderer.CloudGeometry cachedGeometryIris;

    @Inject(method={"writeVertex"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void writeIrisVertex(long buffer, float x, float y, float z, int color, CallbackInfoReturnable<Long> cir) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            CloudVertex.put(buffer, x, y, z, color, computedNormal);
            cir.setReturnValue((Object)(buffer + 20L));
        }
    }

    @Inject(method={"emitCellGeometry2D"}, at={@At(value="HEAD")}, remap=false)
    private static void computeNormal2D(VertexBufferWriter writer, int faces, int color, float x, float z, CallbackInfo ci) {
        computedNormal = NORMALS[0];
    }

    @Inject(method={"emitCellGeometry3D"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/immediate/CloudRenderer$CloudFace;ordinal()I")}, remap=false)
    private static void computeNormal3D(VertexBufferWriter writer, int visibleFaces, int baseColor, float posX, float posZ, boolean interior, CallbackInfo ci, @Local(ordinal=4) int face) {
        computedNormal = NORMALS[face];
    }

    @ModifyArg(remap=false, method={"emitCellGeometry3D"}, at=@At(value="INVOKE", target="Lorg/lwjgl/system/MemoryStack;nmalloc(I)J"))
    private static int allocateNewSize(int size) {
        return IrisApi.getInstance().isShaderPackInUse() ? 480 : size;
    }

    @ModifyArg(method={"rebuildGeometry"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/Tesselator;begin(Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;Lcom/mojang/blaze3d/vertex/VertexFormat;)Lcom/mojang/blaze3d/vertex/BufferBuilder;"), index=1)
    private static class_293 rebuild(class_293 p_350837_) {
        return IrisApi.getInstance().isShaderPackInUse() ? IrisVertexFormats.CLOUDS : p_350837_;
    }

    @ModifyArg(method={"emitCellGeometry3D"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/api/vertex/buffer/VertexBufferWriter;push(Lorg/lwjgl/system/MemoryStack;JILcom/mojang/blaze3d/vertex/VertexFormat;)V"), index=3)
    private static class_293 modifyArgIris(class_293 vertexFormatDescription) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return IrisVertexFormats.CLOUDS;
        }
        return ColorVertex.FORMAT;
    }

    @ModifyArg(remap=false, method={"emitCellGeometry2D"}, at=@At(value="INVOKE", target="Lorg/lwjgl/system/MemoryStack;nmalloc(I)J"))
    private static int allocateNewSize2D(int size) {
        return IrisApi.getInstance().isShaderPackInUse() ? 80 : size;
    }

    @ModifyArg(method={"emitCellGeometry2D"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/api/vertex/buffer/VertexBufferWriter;push(Lorg/lwjgl/system/MemoryStack;JILcom/mojang/blaze3d/vertex/VertexFormat;)V"), index=3)
    private static class_293 modifyArgIris2D(class_293 vertexFormatDescription) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return IrisVertexFormats.CLOUDS;
        }
        return ColorVertex.FORMAT;
    }

    @Redirect(method={"render"}, at=@At(remap=false, value="FIELD", target="Lnet/caffeinemc/mods/sodium/client/render/immediate/CloudRenderer;cachedGeometry:Lnet/caffeinemc/mods/sodium/client/render/immediate/CloudRenderer$CloudGeometry;", ordinal=0))
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CloudRenderer.CloudGeometry changeGeometry(CloudRenderer instance) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return this.cachedGeometryIris;
        }
        return this.cachedGeometry;
    }

    @Redirect(method={"render"}, at=@At(remap=false, value="FIELD", target="Lnet/caffeinemc/mods/sodium/client/render/immediate/CloudRenderer;cachedGeometry:Lnet/caffeinemc/mods/sodium/client/render/immediate/CloudRenderer$CloudGeometry;", ordinal=1))
    private void changeGeometry2(CloudRenderer instance, CloudRenderer.CloudGeometry value) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            this.cachedGeometryIris = value;
        } else {
            this.cachedGeometry = value;
        }
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lnet/caffeinemc/mods/sodium/client/render/immediate/CloudRenderer;shaderProgram:Lnet/minecraft/client/renderer/ShaderInstance;"))
    private class_5944 changeShader(CloudRenderer instance) {
        return this.getClouds();
    }

    @Unique
    private class_5944 getClouds() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof ShaderRenderingPipeline) {
            return ((ShaderRenderingPipeline)pipeline).getShaderMap().getShader(ShaderKey.CLOUDS_SODIUM);
        }
        return this.shaderProgram;
    }
}

